/***************************************************************************
 *   Copyright (C) 2011 by Jeremy Burton   *
 *   jburton@39net-w04   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <stdio.h>

#include <QPainter>

#include "dom.h"
#include "baseitem.h"

baseitem::baseitem()
{
  centre.setX(0);
  centre.setY(0);
  angle=0.0;
  strokewidth=0.0;
  stroke = true;
  strokecolor = Qt::black;
  fill = false;
  fillcolor = Qt::white;
  centrelock = true;
  sizelock = false;
  anglelock = false;
}

baseitem::~baseitem() {}

void baseitem::paint_handle_move(QPainter &painter,const QPoint &ctr)
{
  if (centrelock) return;

  //move_handle = ctr;

  painter.setBrush(Qt::green);
  painter.setPen(Qt::NoPen);
  painter.drawRect(ctr.x()-MOVE_HANDLE_SIZE/2,ctr.y()-MOVE_HANDLE_SIZE/2,MOVE_HANDLE_SIZE,MOVE_HANDLE_SIZE);
}

void baseitem::paint_handle_size(QPainter &painter,const QPoint &rad)
{
  if (sizelock) return;
  painter.setBrush(Qt::blue);
  painter.setPen(Qt::NoPen);
  painter.drawRect(rad.x()-SIZE_HANDLE_SIZE/2,rad.y()-SIZE_HANDLE_SIZE/2,SIZE_HANDLE_SIZE,SIZE_HANDLE_SIZE);
}

void baseitem::paint_handle_size(QPainter &painter,const QPoint &ctr,int rx,int ry,int offsetang)
{
  if (sizelock) return;

  double
    ang = DegToRad(offsetang);
  QPoint
    rad(ctr.x()+rx*sin(ang),ctr.y()-ry*cos(ang));

  paint_handle_size(painter,rad);
}


void baseitem::paint_handle_angle(QPainter &painter,const QPoint &ctr,int r)
{
  if (anglelock) return;

  double
    ang = DegToRad(angle);
  int
    router = r+ANGLE_HANDLE_EXTEND;
  QPen
    pen1(Qt::DashLine);
  QPoint
    rad(ctr.x()+router*sin(ang),ctr.y()-router*cos(ang));

  pen1.setColor(Qt::red);
  painter.setPen(pen1);
  painter.drawLine(ctr,rad);
  painter.setBrush(Qt::red);
  painter.setPen(Qt::NoPen);
  painter.drawEllipse(rad,ANGLE_HANDLE_SIZE,ANGLE_HANDLE_SIZE);
}

void baseitem::paint_handle_angle2(QPainter &painter,const QPoint &ctr,int r)
{
  if (anglelock) return;

/*  double
    ang = DegToRad(angle);*/
  int
    router = r+ANGLE_HANDLE_EXTEND;
  QPen
    pen1(Qt::DashLine);
  QPoint
    rad(ctr.x(),ctr.y()-router);

  //Using rotated canvas
  pen1.setColor(Qt::red);
  painter.setPen(pen1);
  painter.drawLine(ctr,rad);
  painter.setBrush(Qt::red);
  painter.setPen(Qt::NoPen);
  painter.drawEllipse(rad,ANGLE_HANDLE_SIZE,ANGLE_HANDLE_SIZE);
}

void baseitem::fromDom(QDomDocument &doc,QDomElement &element)
{
  stroke = element.attribute("stroke", "1").toInt() != 0;
  fill = element.attribute("fill", "0").toInt() != 0;
  centrelock = element.attribute("centrelock", "0").toInt() != 0;
  sizelock = element.attribute("sizelock", "0").toInt() != 0;
  anglelock = element.attribute("anglelock", "0").toInt() != 0;

  for (QDomNode n = element.firstChild(); !n.isNull(); n = n.nextSibling())
  {
    QDomElement e = n.toElement(); // try to convert the node to an element.
    if(!e.isNull())
    {
      if (e.tagName() == "x")
        centre.setX(e.text().toDouble());
      else if (e.tagName() == "y")
        centre.setY(e.text().toDouble());
      else if (e.tagName() == "fillcolor")
        fillcolor.setRgba(e.text().toULong());
      else if (e.tagName() == "strokecolor")
        strokecolor.setRgba(e.text().toULong());
      else if (e.tagName() == "strokewidth")
        strokewidth = e.text().toDouble();
      else if (e.tagName() == "angle")
	angle = e.text().toDouble();
    }
  }
}

void baseitem::toDom_content(QDomDocument &doc,QDomElement &element)
{
  element.setAttribute("fill",fill);
  element.setAttribute("stroke",stroke);
  element.setAttribute("centrelock",centrelock);
  element.setAttribute("sizelock",sizelock);
  element.setAttribute("anglelock",anglelock);

  toDom_Text(doc,element,"x",centre.x());
  toDom_Text(doc,element,"y",centre.y());
  toDom_Text(doc,element,"strokewidth",strokewidth);
  toDom_Text(doc,element,"strokecolor",strokecolor.rgba());
  toDom_Text(doc,element,"fillcolor",fillcolor.rgba());
  toDom_Text(doc,element,"angle",angle);
}
