/***************************************************************************
 *   Copyright (C) 2011 by Jeremy Burton   *
 *   jburton@39net-w04   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CANVAS_H
#define CANVAS_H

#include <QWidget>
#include <QDomDocument>
#include <QDomElement>

#include "dom.h"
#include "textitem.h"

class CCanvas : public QWidget
{
Q_OBJECT
public:
    CCanvas(QWidget *);
    ~CCanvas();
    void output(QString &fileName);
    void setZoom(double v);
    void setGridType(int v);
    double getZoom();
    double extent();
    void auto_zoom();
    void toDom(QDomDocument &doc,QDomElement &parent);
    void fromDom(QDomDocument &doc,QDomElement &element);
    void clear();

    QString filename;
    bool modified;

    QPoint centre;
    int curitem;
    QList<baseitem *> items;
//boxitem *box;
    bool auto_zoom_req,auto_zoom_block,preview;
    int grid_type;
    //textitem item2;

protected:
    void resizeEvent(QResizeEvent *event);
    void paintEvent(QPaintEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void mousePressEvent ( QMouseEvent * event );
    void mouseReleaseEvent ( QMouseEvent * event );

private:
    enum EMouseMode {MouseIdle=0, ItemMove, ItemAngle, ResizeRadius1, ResizeRadius2, ResizeRadius3, TextAnchorAngle, FontHeight, ResizeBox,OffsetMove } mousemode;
    QPoint mouseorig;
    double zoom;

signals:
    void itemChange(int index);
    void canvasChange();
};

#endif
