/***************************************************************************
 *   Copyright (C) 2011 by Jeremy Burton   *
 *   jburton@39net-w04   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CIRCTEXT_H
#define CIRCTEXT_H

#include <QMainWindow>

#include "version.h"
#include "ui_mainwindow.h"

class CCirctext : public QMainWindow
{
Q_OBJECT
public:
    static const CVersion version;

    CCirctext();
    ~CCirctext();
    void itemsLst_populate();
    bool fromDom(QDomDocument &doc);

public slots:
    //Base
    void Slot_centrePropChange(double vx,double vy);
    void Slot_strokewidthSpinChange(double v);
    void Slot_strokeChkToggle(bool checked);
    void Slot_strokeColorBtnClick();
    void Slot_fillChkToggle(bool checked);
    void Slot_fillColorBtnClick();
    void Slot_angleSpinChange(double v);
    void Slot_anchorangleSpinChange(double v);
    void Slot_centrelockChkToggle(bool);
    void Slot_sizelockChkToggle(bool);
    void Slot_anglelockChkToggle(bool);

    //Polar
    void Slot_radiusPropChange(double vx,double vy);
    void Slot_circularChkToggle(bool checked);

    //Text
    void Slot_spacingSpinChange(double v);
    void Slot_fontheightSpinChange(double v);
    void Slot_txtEditChange(const QString &t);
    void Slot_reverseChkToggle(bool checked);
    void Slot_smallcapsChkToggle(bool checked);
    void Slot_drawpathChkToggle(bool checked);
    void Slot_fontfamilyCbChange(int index);
    void Slot_fontweightCbChange(int index);
    void Slot_fontstretchSpinChange(int v);
    void Slot_refcharEditChange(const QString &t);
    void Slot_justifyCbChange(int index);

    //Polygon
    void Slot_pointsSpinChange(int);
    void Slot_incrementSpinChange(int);

    //Radial
    void Slot_radius3SpinChange(double v);

    //Box
    void Slot_sizePropChange(double vx,double vy);
    void Slot_constrainpropChkToggle(bool checked);
    void Slot_squareChkToggle(bool checked);

    //Shape
    void Slot_nameEdtChange(const QString &t);
    void Slot_offsetPropChange(double vx,double vy);
    void Slot_scaleSpinChange(double v);
    void Slot_pointsEditChange();

    void Slot_actionPreviewTrigger();

    void Slot_zoomChange(int);
    void Slot_itemChange(int index);
    void Slot_canvasChange();
    void Slot_itemSelect(int index);

    //Item List Action / Add buttons
    void Slot_itemAdd_Text1();
    void Slot_itemAdd_Text2();
    void Slot_itemAdd_Box();
    void Slot_itemAdd_Circle();
    void Slot_itemAdd_Ellipse();
    void Slot_itemAdd_Polygon();
    void Slot_itemAdd_Radial();
    void Slot_itemAdd_Shape();
    void Slot_itemCopyBtnClick();
    void Slot_itemDelBtnClick();

    void Slot_upBtnClick();
    void Slot_downBtnClick();

    void Slot_new();
    void Slot_load();
    void Slot_save();
    void Slot_saveas();
    void Slot_exportPDF();
    void Slot_actionTestTrigger();
    void Slot_gridMenuTrigger(QAction *);
    void Slot_about();

protected:
    void closeEvent(QCloseEvent *);

private:
    struct prop_s
    {
      QLabel *label;
      QWidget *widget;
    };

    void create_menus();
    void create_toolbars();
    baseitem *curitem();
    void itemAdd(baseitem *item);
    void props_add(struct prop_s *props);
    void props_block(struct prop_s *props);
    void props_clear();

    void load();
    void save(const QString &filename);
    int save_check();

    //bool itemsCb_block;

    Ui::MainWindow *mainWidget;
};

#endif
