/***************************************************************************
 *   Copyright (C) 2011 by Jeremy Burton   *
 *   jburton@39net-w04   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "cpointwidget.h"

CPointWidget::CPointWidget(QWidget *parent) : QWidget(parent)
{
  setupUi(this);

  _locked = false;

  connect(xSpin, SIGNAL(valueChanged(double)), this, SLOT(Slot_SpinChange()));
  connect(ySpin, SIGNAL(valueChanged(double)), this, SLOT(Slot_SpinChange()));
}

void CPointWidget::blockSignals(bool v)
{
  QWidget::blockSignals(v);
  xSpin->blockSignals(v);
  ySpin->blockSignals(v);
}

void CPointWidget::setMinimum(double v)
{
  //blockSignals(true);
  xSpin->setMinimum(v);
  ySpin->setMinimum(v);
  //blockSignals(false);
}

void CPointWidget::setMaximum(double v)
{
  xSpin->setMaximum(v);
  ySpin->setMaximum(v);
}

void CPointWidget::setValue(double vx,double vy)
{
  if (_locked && vx!=vy)
    vy=vx;
  blockSignals(true);
  xSpin->setValue(vx);
  ySpin->setValue(vy);
  blockSignals(false);
  emit valueChanged(xSpin->value(),ySpin->value());
}

void CPointWidget::setLocked(bool v)
{
  _locked = v;
  ySpin->setEnabled(!_locked);
}

void CPointWidget::Slot_SpinChange()
{
  if (_locked && xSpin->value()!=ySpin->value())
    ySpin->setValue(xSpin->value());
  emit valueChanged(xSpin->value(),ySpin->value());
}
