/***************************************************************************
 *   Copyright (C) 2011 by Jeremy Burton   *
 *   jburton@39net-w04   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <QPainter>

#include "itemstack.h"

#define BOX_HEIGHT 40
#define FONT_HEIGHT 16

CItemStack::CItemStack(QWidget *parent) : QWidget(parent)
{
  items = NULL;
  hoverindex = -1;
}

CItemStack::~CItemStack()
{
}

void CItemStack::setItems(QList<baseitem *> *p)
{
  items = p;
}

void CItemStack::paintEvent(QPaintEvent */*event*/)
{
  if (!items)
    return;

  int
    n=items->size(),
    w = width()-10,
    h = BOX_HEIGHT,
    x,y;
  QPen
    boxpen(Qt::SolidLine),
    textpen(Qt::SolidLine);
  QBrush
    boxbrush(Qt::SolidPattern);
  QFont
    font(this->font());

  QPainter painter(this);

  font.setPixelSize(FONT_HEIGHT);
  painter.setFont(font);
  painter.setBrush(Qt::cyan);

  x=5;
  y=5;
  for (int i=0;i<n;i++)
  {
    baseitem *item = items->at(i);
    if (i==hoverindex) boxpen.setColor(Qt::white); else boxpen.setColor(Qt::black); 
    switch (item->getType())
    {
      case baseitem::textitem1_type:	boxbrush.setColor(Qt::darkBlue); textpen.setColor(Qt::white); break;
      case baseitem::textitem2_type:	boxbrush.setColor(Qt::blue); textpen.setColor(Qt::white); break;
      case baseitem::boxitem_type:	boxbrush.setColor(Qt::red); textpen.setColor(Qt::black); break;
      case baseitem::polygonitem_type:	boxbrush.setColor(Qt::green); textpen.setColor(Qt::black); break;
      case baseitem::radialitem_type:	boxbrush.setColor(Qt::cyan); textpen.setColor(Qt::black); break;
      case baseitem::ellipseitem_type:	boxbrush.setColor(Qt::magenta); textpen.setColor(Qt::black); break;
      case baseitem::shapeitem_type:	boxbrush.setColor(Qt::darkGray); textpen.setColor(Qt::white); break;
    }
    painter.setPen(boxpen);
    painter.setBrush(boxbrush);
    painter.drawRect(x,y,w,h);
    painter.setPen(textpen);
    painter.drawText(x+2,y+2,w-4,h-4,Qt::AlignLeft|Qt::AlignVCenter|Qt::TextWordWrap,item->describe());
    y+=h+4;
  }
}

void CItemStack::mouseReleaseEvent(QMouseEvent *event)
{
  int n = (event->y()-5) / (BOX_HEIGHT+4);
  if (n>=0 && n<items->size())
    emit itemSelect(n);
}

void CItemStack::mouseMoveEvent(QMouseEvent *event)
{
  hoverindex = (event->y()-5) / (BOX_HEIGHT+4);
  update();
}

void CItemStack::leaveEvent(QEvent *)
{
  hoverindex = -1;
}