/***************************************************************************
 *   Copyright (C) 2011 by Jeremy Burton   *
 *   jburton@39net-w04   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <math.h>
#include <QPainter>

#include <stdio.h>

#include "dom.h"
#include "polygonitem.h"

polygonitem::polygonitem()
{
  points=6;
  increment=1;
  radius1=40.0;
  strokewidth=1.0;
  fill=false;
  fillcolor=Qt::white;
}

////////////////////////////////////////////////////////////////////////////////

baseitem *polygonitem::dup()
{
  baseitem *item = new polygonitem;
  *item = *this;
  return item;
}

////////////////////////////////////////////////////////////////////////////////

double polygonitem::extent()
{
  return radius1+strokewidth/2.0;
}

////////////////////////////////////////////////////////////////////////////////

QString polygonitem::describe()
{
  return QString("Polygon: %1 point").arg(points);
}

void polygonitem::toDom(QDomDocument &doc,QDomElement &parent)
{
  QDomElement aw = doc.createElement( "polygonitem" );

 // aw.setAttribute(QString("constrainprop"),constrainprop);

  polaritem::toDom_content(doc,aw);

  toDom_Text(doc,aw,"points",points);
  toDom_Text(doc,aw,"increment",increment);

  parent.appendChild(aw);
}

void polygonitem::fromDom(QDomDocument &doc,QDomElement &element)
{
  polaritem::fromDom(doc,element);

  //constrainprop = element.attribute("constrainprop", "1").toInt() != 0;

  QDomNode n = element.firstChild();
  while(!n.isNull()) 
  {
    QDomElement e = n.toElement(); // try to convert the node to an element.
    if(!e.isNull())
    {
      if (e.tagName() == "points")
        points = e.text().toInt();
      else if (e.tagName() == "increment")
	increment = e.text().toInt();
    }
    n = n.nextSibling();
  }
}

void polygonitem::paint_handles(QPainter &painter, double zoom)
{
  double
    r = radius1*zoom,
    ang1 = 360.0/(double)points;

  QPoint
    ctr(centre.x()*zoom,-centre.y()*zoom);

  move_handle = ctr;
  angle_handle.setPolar(ctr,r+ANGLE_HANDLE_EXTEND,angle);
  radius1_handle.setPolar(ctr,r,ang1+angle);

  paint_handle_move(painter,ctr);
  paint_handle_size(painter,ctr,r,r,ang1+angle);
  paint_handle_angle(painter,ctr,r);
}

/*
void polygonitem::paint(QPainter &painter, bool selected, double zoom)
{
  //int
    //dpix = painter.device()->logicalDpiX(),
    //dpiy = painter.device()->logicalDpiY();
  int
    r=radius*zoom,
    x=centre.x()*zoom,
    y=-centre.y()*zoom;

  QPen pen1(Qt::SolidLine);

  pen1.setWidth(strokewidth*zoom);
  pen1.setJoinStyle(Qt::MiterJoin);

  if (selected)
    pen1.setColor(strokecolor);
  else
    pen1.setColor(Qt::darkGray);

  if (fill)
    painter.setBrush(fillcolor);
  else
    painter.setBrush(Qt::NoBrush);

  painter.setPen(pen1);
  QPoint p[points];
  int i;
  double ang;
  for (i=0;i<points;i++)
  {
    ang = angle/180.0*3.1415926 + 2.0*3.1415926/(double)points * (double)(i*increment);
    p[i].setX(x+r*sin(ang));
    p[i].setY(y-r*cos(ang));
  }
  painter.drawPolygon(p,points);
}
*/
void polygonitem::paint(QPainter &painter, bool selected, double zoom)
{
  int
    //dpix = painter.device()->logicalDpiX(),
    //dpiy = painter.device()->logicalDpiY();
    i;
  double
    //r=radius1,
    //x=centre.x(),
    //y=-centre.y();
    ang;
  QPen
    pen1(Qt::SolidLine);
  QColor
    scolor(strokecolor),
    fcolor(fillcolor);
  QPointF
    p[points];

  painter.scale(zoom,zoom);
  painter.translate(centre.x(),-centre.y());

  if (!selected)
  {
    scolor.setAlpha(127);
    fcolor.setAlpha(127);
  }

  if (stroke)
  {
    pen1.setWidth(strokewidth);
    pen1.setJoinStyle(Qt::MiterJoin);
    pen1.setColor(scolor);
    painter.setPen(pen1);
  }
  else
    painter.setPen(Qt::NoPen);

  if (fill)
    painter.setBrush(fcolor);
  else
    painter.setBrush(Qt::NoBrush);

  for (i=0;i<points;i++)
  {
    ang = DegToRad(angle) + 2.0*pi/(double)points * (double)(i*increment);
    p[i].setX(/*x+*/radius1*sin(ang));
    p[i].setY(/*y-*/-radius1*cos(ang));
  }
  painter.drawPolygon(p,points);
}

void polygonitem::output(QPainter &painter)
{
  int
    dpix = painter.device()->logicalDpiX(),
    dpiy = painter.device()->logicalDpiY(),
    r = realtodev(radius1,dpix),
    x = realtodev(centre.x(),dpix),
    y = realtodev(-centre.y(),dpiy),
    i;
  double
    ang;
  QPoint
    p[points];
  QPen
    pen1(strokecolor);

  painter.translate(x,-y);

  if (stroke)
  {
    pen1.setWidth(realtodev(strokewidth,dpix));
    pen1.setJoinStyle(Qt::MiterJoin);
    painter.setPen(pen1);
  }
  else
    painter.setPen(Qt::NoPen);

  if (fill)
    painter.setBrush(fillcolor);
  else
    painter.setBrush(Qt::NoBrush);

  for (i=0;i<points;i++)
  {
    ang = angle/180.0*3.1415926 + 2.0*3.1415926/(double)points * (double)(i*increment);
    p[i].setX(r*sin(ang));
    p[i].setY(-r*cos(ang));
  }
  painter.drawPolygon(p,points);
}
