/***************************************************************************
 *   Copyright (C) 2011 by Jeremy Burton   *
 *   jburton@39net-w04   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef POLYGONITEM_H
#define POLYGONITEM_H

#include <textitem.h>

class polygonprops
{
public:
    int points;
    int increment;
};

class polygonitem : public polaritem, public polygonprops
{
public:
    polygonitem();

    EItemType getType() {return polygonitem_type;}

    void paint(QPainter &painter, bool selected, double zoom);
    void paint_handles(QPainter &painter, double zoom);
    void output(QPainter &painter);
    void toDom(QDomDocument &doc,QDomElement &parent);
    void fromDom(QDomDocument &doc,QDomElement &element);
    baseitem *dup();
    double extent();
    QString describe();

    //int points;
    //int increment;
};

#endif
