/***************************************************************************
 *   Copyright (C) 2011 by Jeremy Burton   *
 *   jburton@39net-w04   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef TEXTITEM_H
#define TEXTITEM_H

#include <math.h>

#include "baseitem.h"

class polarprops
{
public:
  qreal radius1,radius2;
  bool circular;
};

class polaritem: public baseitem, public polarprops
{
public:
  polaritem();
  virtual ~polaritem();
  virtual void fromDom(QDomDocument &doc,QDomElement &element);
  virtual void toDom_content(QDomDocument &doc,QDomElement &element);

  CPoint radius1_handle,radius2_handle;

  //Props
  //qreal radius1,radius2;
  //bool circular;
};

/*
class circleitem : public polaritem
{
public:
    circleitem();

    item_type_e getType() {return circleitem_type;}

    void paint(QPainter &painter, bool selected, double zoom);
    void paint_handles(QPainter &painter, double zoom);
    void output(QPainter &painter);
    void toDom(QDomDocument &doc,QDomElement &parent);
    void fromDom(QDomDocument &doc,QDomElement &element);
    QString describe();
};
*/
class radialprops
{
public:
    qreal radius3;
};

class radialitem : public polaritem, public radialprops
{
public:
    radialitem();

    EItemType getType() {return radialitem_type;}

    void paint(QPainter &painter, bool selected, double zoom);
    void paint_handles(QPainter &painter, double zoom);
    void output(QPainter &painter);
    void toDom(QDomDocument &doc,QDomElement &parent);
    void fromDom(QDomDocument &doc,QDomElement &element);
    baseitem *dup();
    double extent();
    QString describe();

    CPoint radius3_handle;

    //qreal radius3;
};

class textprops
{
public:
    enum ETextJustify {JustifyCentre = 0, JustifyLeft, JustifyRight};

    QString fontfamily;
    int fontweight,fontstretch;
    qreal spacing,fontheight;
    QString str;
    QString refchar;
    bool forward,smallcaps,drawpath;
    qreal anchorangle;
    ETextJustify justify;
};

class textitem : public polaritem, public textprops
{
public:

    textitem(const QString &s = "Text");
    virtual ~textitem();

    double extent();

    void paint_handle_anchorangle(QPainter &painter,const QPoint &ctr,int rx1,int ry1);

    void toDom_content(QDomDocument &doc,QDomElement &element);
    void fromDom(QDomDocument &doc,QDomElement &element);

    CPoint anchorangle_handle,fontheight_handle;

    //Props
/*
    QString fontfamily;
    int fontweight,fontstretch;
    qreal spacing,fontheight;
    QString str;
    QString refchar;
    bool forward,smallcaps;
    qreal anchorangle;
    text_justify_e justify;
*/

protected:
    int reftext_height(QPainter &painter,QFont &font);
};

class textitem1 : public textitem
{
public:
    textitem1(const QString &s = "Text");

    EItemType getType() {return textitem1_type;}

    void paint(QPainter &painter, bool selected, double zoom);
    void paint_handles(QPainter &painter, double zoom);
    void output(QPainter &painter);
    void toDom(QDomDocument &doc,QDomElement &parent);
    void fromDom(QDomDocument &doc,QDomElement &element);
    baseitem *dup();
    QString describe();
};

#endif
